function [ MAPOUT ] = dilateslipsurfaces( MAP, legenditems, imagevaluesused )
%DILATESLIPSURFACES Uses image processing dilate functiont to increase the
%eidth of slip surfaces by one pixel on both sides.

% dilate slip surfaces to improve their visibility:
    MAPOUT = MAP;
    for idx = 1 : length( legenditems),
        if strncmpi( strtrim(legenditems{idx}), 'slip surface',12 ),
            ssvalue = imagevaluesused(idx);

            ssmap = MAP == ssvalue;
            ssmapdil = imdilate(ssmap, strel('diamond', 1));

            MAPOUT( ssmapdil==1 ) = ssvalue;

        end
    end
    

end

